/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.FactoryFinder;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class DatatypeFactory {
    public static final String DATATYPEFACTORY_PROPERTY = "javax.xml.datatype.DatatypeFactory";
    public static final String DATATYPEFACTORY_IMPLEMENTATION_CLASS = "com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl";

    protected DatatypeFactory() {
    }

    public static DatatypeFactory newInstance() throws DatatypeConfigurationException {
        try {
            return (DatatypeFactory)FactoryFinder.find(DATATYPEFACTORY_PROPERTY, DATATYPEFACTORY_IMPLEMENTATION_CLASS);
        }
        catch (FactoryFinder.ConfigurationError e) {
            throw new DatatypeConfigurationException(e.getMessage(), e.getException());
        }
    }

    public abstract Duration newDuration(String var1);

    public abstract Duration newDuration(long var1);

    public abstract Duration newDuration(boolean var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6, BigDecimal var7);

    public Duration newDuration(boolean isPositive, int years, int months, int days, int hours, int minutes, int seconds) {
        BigInteger realYears = years != Integer.MIN_VALUE ? BigInteger.valueOf(years) : null;
        BigInteger realMonths = months != Integer.MIN_VALUE ? BigInteger.valueOf(months) : null;
        BigInteger realDays = days != Integer.MIN_VALUE ? BigInteger.valueOf(days) : null;
        BigInteger realHours = hours != Integer.MIN_VALUE ? BigInteger.valueOf(hours) : null;
        BigInteger realMinutes = minutes != Integer.MIN_VALUE ? BigInteger.valueOf(minutes) : null;
        BigDecimal realSeconds = seconds != Integer.MIN_VALUE ? BigDecimal.valueOf(seconds) : null;
        return this.newDuration(isPositive, realYears, realMonths, realDays, realHours, realMinutes, realSeconds);
    }

    public Duration newDurationDayTime(String lexicalRepresentation) {
        return this.newDuration(lexicalRepresentation);
    }

    public Duration newDurationDayTime(long durationInMilliseconds) {
        return this.newDuration(durationInMilliseconds);
    }

    public Duration newDurationDayTime(boolean isPositive, BigInteger day, BigInteger hour, BigInteger minute, BigInteger second) {
        return this.newDuration(isPositive, null, null, day, hour, minute, second != null ? new BigDecimal(second) : null);
    }

    public Duration newDurationDayTime(boolean isPositive, int day, int hour, int minute, int second) {
        return this.newDurationDayTime(isPositive, BigInteger.valueOf(day), BigInteger.valueOf(hour), BigInteger.valueOf(minute), BigInteger.valueOf(second));
    }

    public Duration newDurationYearMonth(String lexicalRepresentation) {
        return this.newDuration(lexicalRepresentation);
    }

    public Duration newDurationYearMonth(long durationInMilliseconds) {
        return this.newDuration(durationInMilliseconds);
    }

    public Duration newDurationYearMonth(boolean isPositive, BigInteger year, BigInteger month) {
        return this.newDuration(isPositive, year, month, null, null, null, null);
    }

    public Duration newDurationYearMonth(boolean isPositive, int year, int month) {
        return this.newDurationYearMonth(isPositive, BigInteger.valueOf(year), BigInteger.valueOf(month));
    }

    public abstract XMLGregorianCalendar newXMLGregorianCalendar();

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(String var1);

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar var1);

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(BigInteger var1, int var2, int var3, int var4, int var5, int var6, BigDecimal var7, int var8);

    public XMLGregorianCalendar newXMLGregorianCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond, int timezone) {
        BigInteger realYear = year != Integer.MIN_VALUE ? BigInteger.valueOf(year) : null;
        BigDecimal realMillisecond = null;
        if (millisecond != Integer.MIN_VALUE) {
            if (millisecond < 0 || millisecond > 1000) {
                throw new IllegalArgumentException("javax.xml.datatype.DatatypeFactory#newXMLGregorianCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond, int timezone)with invalid millisecond: " + millisecond);
            }
            realMillisecond = BigDecimal.valueOf(millisecond).movePointLeft(3);
        }
        return this.newXMLGregorianCalendar(realYear, month, day, hour, minute, second, realMillisecond, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarDate(int year, int month, int day, int timezone) {
        return this.newXMLGregorianCalendar(year, month, day, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, int timezone) {
        return this.newXMLGregorianCalendar(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, Integer.MIN_VALUE, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, BigDecimal fractionalSecond, int timezone) {
        return this.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, fractionalSecond, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, int milliseconds, int timezone) {
        BigDecimal realMilliseconds = null;
        if (milliseconds != Integer.MIN_VALUE) {
            if (milliseconds < 0 || milliseconds > 1000) {
                throw new IllegalArgumentException("javax.xml.datatype.DatatypeFactory#newXMLGregorianCalendarTime(int hours, int minutes, int seconds, int milliseconds, int timezone)with invalid milliseconds: " + milliseconds);
            }
            realMilliseconds = BigDecimal.valueOf(milliseconds).movePointLeft(3);
        }
        return this.newXMLGregorianCalendarTime(hours, minutes, seconds, realMilliseconds, timezone);
    }
}

